package org.msh.tb.reports2.me;

import org.msh.tb.reports2.ReportResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class HIVReport {

    public static List<TableData> generate(IndicatorBuilder builder) {
        List<TableData> tables = new ArrayList<TableData>();

        tables.add(generateTable1(builder));

        return tables;
    }

    private static TableData generateTable1(IndicatorBuilder builder) {
        String col = "totalcases key=1:'Total TB cases notified', " +
                "hivres key=0:'HIV Positive' key=1:'HIV Negative' key=null:'HIV Unknown'," +
                "hiv_ctp key=1:'TB/HIV care - CPT' hiv_ctp=1," +
                "hiv_art key=1:'TB/HIV care - ART' hiv_art=1";

        TableData tbl = builder
                .addColumnVariables(col, "gender")
                .addRowVariables("patient-type-rep")
                .addFilter("caseDef", "0") // case definition = bacteriologically diagnosed
                .addFilter("is", "0;2")
                .generate("Breakdown of TB/HIV activities by case category and sex");

        return tbl;
    }

}
